/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.navigator.ViewDisplay;
import com.vaadin.spring.annotation.SpringViewDisplay;
import com.vaadin.spring.internal.SpringViewDisplayRegistrationBean;
import com.vaadin.ui.Component;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;

public class SpringViewDisplayPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
BeanFactoryAware {
    private ApplicationContext applicationContext;
    private ConfigurableListableBeanFactory beanFactory;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringViewDisplayPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (!Component.class.isAssignableFrom(clazz) && !ViewDisplay.class.isAssignableFrom(clazz)) {
            return bean;
        }
        if (this.beanFactory != null) {
            try {
                StandardMethodMetadata metadata;
                Map annotationAttributes;
                BeanDefinition beanDefinition = this.beanFactory.getMergedBeanDefinition(beanName);
                if (beanDefinition.getSource() instanceof StandardMethodMetadata && (annotationAttributes = (metadata = (StandardMethodMetadata)beanDefinition.getSource()).getAnnotationAttributes(SpringViewDisplay.class.getName())) != null) {
                    this.registerSpringViewDisplayBean(beanName);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                LOGGER.warn("No bean definition found for bean [{}] with name [{}] in [{}]", new Object[]{bean, beanName, this});
            }
        }
        if (clazz.isAnnotationPresent(SpringViewDisplay.class)) {
            this.registerSpringViewDisplayBean(clazz);
        }
        return bean;
    }

    protected synchronized void registerSpringViewDisplayBean(Class<?> clazz) {
        ConfigurableListableBeanFactory beanFactory;
        BeanDefinitionRegistry registry = null;
        if (this.applicationContext instanceof BeanDefinitionRegistry) {
            registry = (BeanDefinitionRegistry)this.applicationContext;
        } else if (this.applicationContext instanceof ConfigurableApplicationContext && (beanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory()) instanceof BeanDefinitionRegistry) {
            registry = (BeanDefinitionRegistry)beanFactory;
        }
        if (registry == null) {
            throw new BeanDefinitionStoreException("BeanDefinitionRegistry is not accessible");
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SpringViewDisplayRegistrationBean.class);
        builder.addPropertyValue("beanClass", clazz);
        builder.setScope("vaadin-ui");
        builder.setRole(1);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String name = this.getBeanNameGenerator().generateBeanName((BeanDefinition)beanDefinition, registry);
        boolean alreadyRegistered = this.applicationContext.getBeansOfType(SpringViewDisplayRegistrationBean.class).values().stream().map(SpringViewDisplayRegistrationBean::getBeanClass).anyMatch(clazz::equals);
        if (!alreadyRegistered) {
            registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        }
    }

    protected synchronized void registerSpringViewDisplayBean(String beanName) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SpringViewDisplayRegistrationBean.class);
        builder.addPropertyValue("beanName", (Object)beanName);
        builder.setScope("vaadin-ui");
        builder.setRole(1);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String name = this.getBeanNameGenerator().generateBeanName((BeanDefinition)beanDefinition, registry);
        boolean alreadyRegistered = this.applicationContext.getBeansOfType(SpringViewDisplayRegistrationBean.class).values().stream().map(SpringViewDisplayRegistrationBean::getBeanName).anyMatch(beanName::equals);
        if (!alreadyRegistered) {
            registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }
}

