/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.grid;

import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.shared.Range;
import com.vaadin.shared.data.DataCommunicatorClientRpc;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.List;

public class SizelessDataCommunicator<T>
extends DataCommunicator<T> {
    DataCommunicatorClientRpc rpc = (DataCommunicatorClientRpc)this.getRpcProxy(DataCommunicatorClientRpc.class);
    int knownSize = 0;

    protected void sendDataToClient(boolean initial) {
        Range requestedRows;
        if (this.getDataProvider() == null) {
            return;
        }
        if (initial || this.reset) {
            this.rpc.reset(0);
        }
        if (!(requestedRows = this.getPushRows()).isEmpty()) {
            int limit;
            List rowsToPush;
            int offset = requestedRows.getStart();
            int lastIndex = offset + (rowsToPush = this.fetchItemsWithRange(offset, limit = requestedRows.length() + this.getMinPushSize())).size();
            if (lastIndex > this.knownSize) {
                int rowsToAdd = lastIndex - this.knownSize;
                this.rpc.insertRows(this.knownSize, rowsToAdd + (rowsToPush.size() == limit ? 1 : 0));
                this.knownSize = lastIndex;
            } else if (rowsToPush.size() < requestedRows.length()) {
                int rowsToRemove = Math.max(requestedRows.length() - rowsToPush.size(), this.knownSize - lastIndex);
                this.knownSize = lastIndex;
                this.rpc.removeRows(this.knownSize, rowsToRemove);
            }
            this.pushData(offset, rowsToPush);
        }
        if (!this.getUpdatedData().isEmpty()) {
            JsonArray dataArray = Json.createArray();
            int i = 0;
            for (Object data : this.getUpdatedData()) {
                dataArray.set(i++, (JsonValue)this.getDataObject(data));
            }
            this.rpc.updateData(dataArray);
        }
        this.setPushRows(Range.withLength((int)0, (int)0));
        this.getUpdatedData().clear();
    }

    public int getDataProviderSize() {
        return this.knownSize;
    }
}

