/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fluency.server;

import com.vaadin.server.Sizeable;
import org.vaadin.viritin.MSize;

public interface FluentSizeable<S extends FluentSizeable<S>>
extends Sizeable {
    default public S withHeight(String height) {
        this.setHeight(height);
        return (S)this;
    }

    default public S withHeight(float height, Sizeable.Unit unit) {
        this.setHeight(height, unit);
        return (S)this;
    }

    default public S withWidth(String width) {
        this.setWidth(width);
        return (S)this;
    }

    default public S withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return (S)this;
    }

    default public S withFullSize() {
        this.setSizeFull();
        return (S)this;
    }

    default public S withFullWidth() {
        return this.withWidth("100%");
    }

    default public S withFullHeight() {
        return this.withHeight("100%");
    }

    default public S withUndefinedSize() {
        this.setSizeUndefined();
        return (S)this;
    }

    default public S withUndefinedWidth() {
        this.setWidthUndefined();
        return (S)this;
    }

    default public S withUndefinedHeight() {
        this.setHeightUndefined();
        return (S)this;
    }

    default public S withSize(String width, String height) {
        this.setWidth(width);
        this.setHeight(height);
        return (S)this;
    }

    default public S withSize(MSize mSize) {
        this.setWidth(mSize.getWidth(), mSize.getWidthUnit());
        this.setHeight(mSize.getHeight(), mSize.getHeightUnit());
        return (S)this;
    }
}

