/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.spring.annotation.SpringView;
import org.springframework.util.ClassUtils;

public final class Conventions {
    private Conventions() {
    }

    public static String deriveMappingForView(Class<?> beanClass, SpringView annotation) {
        if (annotation != null && !"USE CONVENTIONS".equals(annotation.name())) {
            return annotation.name();
        }
        Class realBeanClass = ClassUtils.getUserClass(beanClass);
        String mapping = realBeanClass.getSimpleName().replaceFirst("View$", "");
        return Conventions.upperCamelToLowerHyphen(mapping);
    }

    public static String upperCamelToLowerHyphen(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
                if (Conventions.shouldPrependHyphen(string, i)) {
                    sb.append('-');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean shouldPrependHyphen(String string, int i) {
        if (i == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(i - 1))) {
            return true;
        }
        return i + 1 < string.length() && !Character.isUpperCase(string.charAt(i + 1));
    }
}

